/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
enum COL_TRANS_MODE // color transformation modes
{
   CT_RGB,
   CT_RBG,
   CT_GRB,
   CT_GBR,
   CT_BRG,
   CT_BGR,
   CT_MONO,
   CT_HUE,
   CT_HUE2,
   CT_CUSTOM,
   CT_CUSTOM2,
};
Char *CTText[]= // color transformation description
{
   "RGB",
   "RBG",
   "GRB",
   "GBR",
   "BRG",
   "BGR",
   "MONO",
   "HUE",
   "HUE+",
   "CUSTOM",
   "CUSTOM2",
};
Gfx    gfx   ; // Esenthel image
Tabs   tabs  ; // transformation tabs
Slider slider; // transformation power/alpha
/******************************************************************************/
void InitPre()
{
   App.name="Color Transformations";
   PakAdd("../data/engine.pak");
   D.mode(800,600);
}
/******************************************************************************/
Bool Init()
{
   gfx.Import("../data/logo.png",-1,GFX_2D,1);
   Gui+=tabs  .create(Rect_U (0,D.h(),D.w()*2,0.06),0,CTText,ELMS(CTText));
   Gui+=slider.create(Rect_LU(-D.w(),D.h()-0.1,0.4,0.1)).set(1);
        slider.color=WHITE;
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void ApplyColorTransformation(Int mode)
{
   ColorMatrix cm;             // color transformation matrix
   Flt         alpha=slider(); // color transformation power

   switch(mode)
   {
      case CT_RGB : cm.setRGB   (           ).draw(alpha); break;
      case CT_RBG : cm.setRBG   (           ).draw(alpha); break;
      case CT_GRB : cm.setGRB   (           ).draw(alpha); break;
      case CT_GBR : cm.setGBR   (           ).draw(alpha); break;
      case CT_BRG : cm.setBRG   (           ).draw(alpha); break;
      case CT_BGR : cm.setBGR   (           ).draw(alpha); break;
      case CT_MONO: cm.setMono  (           ).draw(alpha); break;
      case CT_HUE : cm.setHue   (Tm.time()/4).draw(alpha); break;
      case CT_HUE2: ColorTransHB(Tm.time()/4,1    ,alpha); break; // use 'ColTransHB' to get correct Hue-Brightness transformation

      case CT_CUSTOM:
      {
         // set custom matrix

         //         dst.r, dst.g, dst.b
         cm.x  .set(1    , 1    , 1    ); // src.r
         cm.y  .set(0    , 0    , 0    ); // src.g
         cm.z  .set(0    , 0    , 0    ); // src.b

         //         add.r, add.g, add.b
         cm.pos.set(0    , 0.2  , 0    ); // 1

         cm.draw(alpha);
      }break;

      case CT_CUSTOM2:
      {
         // set custom matrix #2

         //         dst.r, dst.g, dst.b
         cm.x  .set(0.5  , 0.5  , 0.5  ); // src.r
         cm.y  .set(0.5  , 0.5  , 0.5  ); // src.g
         cm.z  .set(0.3  , 0.3  , 1.0  ); // src.b

         //         add.r, add.g, add.b
         cm.pos.set(0    , 0    , 0    ); // 1

         cm.draw(alpha);
      }break;
   }
}
void Draw()
{
   D.clear();

   // draw
   gfx.drawFs();
   D.rectShadedX(BLACK,RED  , -D.w()/2,-0.7, D.w()/2, -0.75);
   D.rectShadedX(BLACK,GREEN, -D.w()/2,-0.8, D.w()/2, -0.85);
   D.rectShadedX(BLACK,BLUE , -D.w()/2,-0.9, D.w()/2, -0.95);

   // transform colors
   ApplyColorTransformation(tabs());

   // draw gui after transformation
   Gui.draw();
}
/******************************************************************************/
